<?php
/**
 * LiquidThemes Theme Framework
 * Include the TGM_Plugin_Activation class and register the required plugins.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 */

liquid()->load_library( 'class-tgm-plugin-activation' );

/**
 * Register the required plugins for this theme.
 */
add_action( 'tgmpa_register', 'liquid_register_required_plugins' );

function liquid_register_required_plugins() {

	$images = get_template_directory_uri() . '/theme/plugins/images';

	$plugins = array(

		array(
			'name' 		         => esc_html__( 'Logistics Hub Core', 'logistics-hub' ),
			'slug' 		         => 'logistics-hub-core',
			'required' 	         => true,
			'source'             => 'http://api.liquid-themes.com/download.php?type=plugins&file=logistics-hub-core.zip',
			'liquid_logo'        => $images . '/one-core-min.png',
			'version'            => '1.1.6',
			'liquid_author'      => esc_html__( 'Liquid Themes', 'logistics-hub' ),
			'liquid_description' => esc_html__( 'Intelligent and Powerful Elements Plugin, exclusively for Hub WordPress Theme.', 'logistics-hub' ),
		),
		array(
			'name'               => esc_html__( 'Elementor', 'logistics-hub' ),
			'slug'               => 'elementor',
			'required'           => true,
			'liquid_logo'        => $images . '/elementor.png',
			'liquid_author'      => esc_html__( 'Elementor.com', 'logistics-hub' ),
			'liquid_description' => esc_html__( 'Introducing a WordPress website builder, with no limits of design. A website builder that delivers high-end page designs and advanced capabilities, never before seen on WordPress.', 'logistics-hub' )
		),
		array(
			'name'               => esc_html__( 'Metform', 'logistics-hub' ),
			'slug'               => 'metform',
			'required'           => false,
			'liquid_logo'        => $images . '/elementor.png',
			'liquid_author'      => esc_html__( 'Wpmet', 'logistics-hub' ),
			'liquid_description' => esc_html__( 'MetForm, the contact form builder is an addon for Elementor, build any fast and secure contact form on the fly with its drag and drop builder.', 'logistics-hub' )
		),
		array(
			'name'               => esc_html__( 'WooCommerce', 'logistics-hub' ),
			'slug'               => 'woocommerce',
			'required'           => false,
			'liquid_logo'        => $images . '/woo-min.png',
			'liquid_author'      => esc_html__( 'Automattic', 'logistics-hub' ),
			'liquid_description' => esc_html__( 'WooCommerce is the world’s most popular open-source eCommerce solution.', 'logistics-hub' )
		),
		array(
			'name' 		         => esc_html__( 'Hub Booking', 'hub' ),
			'slug' 		         => 'hub-booking',
			'required' 	         => false,
			'source'             => 'http://api.liquid-themes.com/download.php?type=plugins&file=hub-booking.zip',
			'liquid_logo'        => $images . '/one-core-min.png',
			'version'            => '1.1',
			'liquid_author'      => esc_html__( 'Liquid Themes', 'hub' ),
			'liquid_description' => esc_html__( 'Simple booking management system.', 'hub' ),
		),
		array(
			'name'               => esc_html__( 'WP Bottom Menu', 'logistics-hub' ),
			'slug'               => 'wp-bottom-menu',
			'required'           => false,
			'liquid_logo'        => $images . '/one-core-min.png',
			'liquid_author'      => esc_html__( 'Liquid Themes', 'logistics-hub' ),
			'liquid_description' => esc_html__( 'WP Bottom Menu allows you to add a woocommerce supported bottom menu to your site.', 'logistics-hub' )
		),
	);

	/**
	 * Array of configuration settings. Amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * leave the strings uncommented.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
	);

	tgmpa( $plugins, $config );
}